package com.jsrsys.web;
/*
 * JsrSendMail: cloned from Sun Demo program (see notice at end):
 */
import java.util.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;

/**
 * JsrSendMail will create a multipart message. (See Usage notes)
 *
 * @author	Steve Ryder (JSR Systems)
 */
 
public class JsrSendMail {

    static final String COPYRIGHT = 
    "Copyright 2004, JSR Systems. \n             See: www.JsrSys.com/copyright.";

    JsrUtil u       = new JsrUtil();
    JsrSysout     sysout   = new JsrSysout();
    JsrLineIn     input    = new JsrLineIn();
    String        to       = "";
    int           toComma  = 0;
    String        from     = "";
    String        cc       = "";
    String        bcc      = "";
    String        host     = "mail.jsrsys.com";
    String[]      fileName = {""};
	String        msgText  = "";
    StringBuffer  msgBuffer = new StringBuffer();
	String        subject  = "";
	boolean       debug    = false;
	Session       session; 


    public static void main(String[] args)
    {
	  JsrSendMail sendFile = new JsrSendMail();
	  sendFile.setParms(args);
	  sendFile.checkTo();
	  System.exit(0);
	}

    private void checkTo()
    {
	  if (to.indexOf('@') > 0)
	  	  sendMail();
	  else
	  {
	      input.setName(to);
	      while (0 < input.getNext())
	      {
	        to = input.getLine();
	        toComma = to.indexOf(',');
	        if (toComma > 1)
	        {
	           //sysout.display("Splitting to: "+to);
	           cc = to.substring(toComma+1);
	           to = to.substring(0,toComma);
	           //sysout.display("Into to: "+to+" cc: "+cc);
	        }
        
	        sendMail();
	      }
      sysout.display("JsrSendMail--"+u.getDateTimeAll()+" "+COPYRIGHT);
	  }
    }
	private void setParms(String[] parm)
	{
	  sysout.syslog("syslogJsrSendMail.txt");
      sysout.display("JsrSendMail--"+u.getDateTimeAll()+" "+COPYRIGHT);
      int pMax = 0;
	  for (int p = 0; p < parm.length; p++)
	  {
	      if (parm[p].equals("-t")) {to       = parm[++p]; pMax = p;}
	      if (parm[p].equals("-f")) {from     = parm[++p]; pMax = p;}
	      if (parm[p].equals("-s")) {subject  = parm[++p]; pMax = p;}
	      if (parm[p].equals("-h")) {host     = parm[++p]; pMax = p;}
	      if (parm[p].equals("-c")) {cc       = parm[++p]; pMax = p;}
	      if (parm[p].equals("-b")) {bcc      = parm[++p]; pMax = p;}
	      if (parm[p].equals("-m")) {collect  (parm[++p]); pMax = p;}
	      if (parm[p].equals("-d")) {debug    = true;      pMax = p;}
	  }

      msgText = msgBuffer.toString();

	  pMax++;
	  //sysout.display("pMax="+pMax + " msgTextLen="+msgText.length() );
	  boolean error = false;
      if (to.length() == 0)     {sysout.display("JsrSendMail: To      (-t) is required."); error = true;}
      if (from.length() == 0)   {sysout.display("JsrSendMail: From    (-f) is required."); error = true;}
      if (subject.length() == 0){sysout.display("JsrSendMail: Subject (-s) is required."); error = true;}
      if (error)
      {
	     sysout.display("usage: java JsrSendMail <parameters>");
	     sysout.display("            -t <to> -f <from> -s <Subject> -H <smtp.host.com> ");
	     sysout.display("            -m <message>  -c <cc> -b <bcc> <file1> <file2>...");
	     sysout.display("            -t, -f, -s are required.  Others are optional.");
	     sysout.display("            <file1>... are files to be attached.");
	     sysout.display("            if <to> does not contain at least one \"@\", ");
	     sysout.display("                    assume <to> is a toFileName.");
	     sysout.display("                    if toFileLine has \",\" split between to and cc.");
	     sysout.display("            if <message> byte 1 = \":\" use as text, else read file.");
	     sysout.display("            Multiple -m <...> -m <...> are allowed.");
	     System.exit(4);
      }
	  
	  if (parm.length > pMax)
	  {
	     fileName = new String[parm.length - pMax];
	     int p = pMax;
	     for (int f = 0; f < fileName.length; f++) {fileName[f] = parm[p]; p++;}
	  }
	}

    private void collect(String msgFileName)
    {
      if (msgFileName.substring(0,1).equals(":"))
      {
         msgBuffer.append(msgFileName.substring(1));
         msgBuffer.append("\n");
      }
      else
      {
         input.setName(msgFileName);
         while (0 < input.getNext() )
         {
            if (input.getLine().length() > 0)  // don't copy blank lines. 
            {
               msgBuffer.append(input.getLine());
               msgBuffer.append("\n");
            }
         }
      }
    }

    private void setSession()
	{
	// create some properties and get the default Session
	Properties props = System.getProperties();
	props.put("mail.smtp.host", host);
	
	session = Session.getInstance(props, null);
	//session.setDebug(debug);
	}
	
/**
  * sets <I>required</I> host name, ex: smtp.cagi.com
  */
    public void setHost(String newHost)
    {
       host = newHost;
       return;
    }
    
/**
  * sets <I>required</I> to address, ex: sryder@jsrsys.com
  */
    public void setTo(String address)
    {
       to = address;
       return;
    }
    
/**
  * sets cc address, ex: sryder@jsrsys.com
  */
    public void setCc(String address)
    {
       cc = address;
       return;
    }
    
/**
  * sets bcc address, ex: sryder@jsrsys.com
  */
    public void setBcc(String address)
    {
       bcc = address;
       return;
    }
    
/**
  * sets <I>required</I> from address, ex: sryder@jsrsys.com
  */
     public void setFrom(String address)
    {
       from = address;
       return;
    }
    
/**
  * sets <I>required</I> message text, ex: "This is a text message:\nAn example of..."
  */
    public void setMsgText(String newMsgText)
    {
       msgText= newMsgText;
       return;
    }
    
/**
  * sets <I>required</I> subject, ex: "Sending none, one, or many attached files"
  */
    public void setSubject(String newSubject)
    {
       subject = newSubject;
       return;
    }
    
/**
  * sets file name array values.  Note: input is an array of file names.
  * The whole array is processed, but null or zero length entries are skipped. 
  */
    public void setFileName(String[] newFileName)
    {
       fileName = newFileName;
       return;
    }

/**
  * actually sends the mail, does extensive error checking and logs results of send to syslog.
  */
    public void sendMail()
    {
      boolean error = false;
      if (session == null) setSession();
      if (from == null || from.length() < 1)
      {
         sysout.display("JsrSendMail: from is required.");
         error = true;
      }
      if (to == null || to.length() < 1)
      {
         sysout.display("JsrSendMail: to field is required.");
         error = true;
      }
      if (msgText == null || msgText.length() < 1)
      {
         sysout.display("JsrSendMail: msgText is required.");
         error = true;
      }
      if (subject == null || subject.length() < 1)
      {
         sysout.display("JsrSendMail: subject is required.");
         error = true;
      }
      if (host == null || host.length() < 1)
      {
         sysout.display("JsrSendMail: host (SMTP host) is required.");
         error = true;
      }

      if (error)
      {
         sysout.display("JsrSendMail: mail not sent due to above error");
         return;
      }
      
	  try
	  {
	    // create a message
	    MimeMessage msg = new MimeMessage(session);
	    msg.setFrom(new InternetAddress(from));
	    //InternetAddress[] address = {new InternetAddress(to)};
	    //msg.setRecipients(Message.RecipientType.TO, address);
	    msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to, false));
	    msg.setSubject(subject);

	    if ( cc != null &&  cc.length() > 0)
	       msg.setRecipients(Message.RecipientType.CC, InternetAddress.parse(cc, false));
	    if (bcc != null && bcc.length() > 0)
	       msg.setRecipients(Message.RecipientType.BCC, InternetAddress.parse(bcc, false));


	    // create and fill the first message part
	    MimeBodyPart mbp1 = new MimeBodyPart();
	    //sysout.display("MsgText(1)="+msgText.substring(0,1) +" All="+msgText);
	    if (msgText.substring(0,1).equals("<"))
	    {
	        mbp1.setContent(msgText, "text/html");
	        //sysout.display("JsrSendMail: MimeType=text/html");
	    }
	    else
	    {
	        //sysout.display("JsrSendMail: MimeType=text/plain");
	        mbp1.setText(msgText);  // convenience method for setContent().
	    }


	    // create the Multipart and add its parts to it
	    Multipart mp = new MimeMultipart();
	    mp.addBodyPart(mbp1);

	    if (fileName.length > 0)
	    {
	      for (int f = 0; f < fileName.length; f++)
	      {
	        if (fileName[f] != null && fileName[f].length() > 0)
	        {
	          // create the second message part
	          MimeBodyPart mbp2 = new MimeBodyPart();

              // attach the file to the message
   	          FileDataSource fds = new FileDataSource(fileName[f]);
	          mbp2.setDataHandler(new DataHandler(fds));
	          mbp2.setFileName(fds.getName());
	          mp.addBodyPart(mbp2);
	        }
	      }
	    }

	    // add the Multipart to the message
	    msg.setContent(mp);

	    // set the Date: header
	    msg.setSentDate(new Date());
	    
	    // send the message
	    Transport.send(msg);
	    sysout.display   ("JsrSendMail: To: "+ to +" Date: "+u.getDateTimeAll());
	    if (cc.length() > 0)
	       sysout.display("             CC: "+ cc);
	    if (bcc.length() > 0)
	       sysout.display("            BCC: "+ bcc);
	    sysout.display("    Subject: "+ subject);
	    if (fileName.length > 0)
	       for (int f = 0; f < fileName.length; f++)
	       {
	         if (fileName[f] != null && fileName[f].length() > 0) sysout.display("       File: "+ fileName[f]);
	       }
	    
	  } catch (MessagingException mex)
 	    {
	      sysout.display("JsrSendMail--MailError: "+ mex);
	      Exception ex = null;
	      if ((ex = mex.getNextException()) != null)
	      {
  		     sysout.display("JsrSendMail--MailError: "+ ex);
	      }
	    }
    }
/*
 * @(#)sendfile.java	1.11 03/06/19 Copyright 1996-2003 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted.
 *
 * This demonstrates how to use the FileDataSource to send
 * a file via mail.<p>
 *
 * usage: <code>java JsrSendMail <i>to from smtp file1, file2, ...</i></code>
 * where <i>to</i> and <i>from</i> are the destination and
 * origin email addresses, respectively, and <i>smtp</i>
 * is the hostname of the machine that has smtp server
 * running.  <i>file(s)</i> is(are) the file(s) to send. 
 *
 * @author	Christopher Cotton (Sun) modified by Steve Ryder
 */   
}
